% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tukey.R
\name{quantile.Tukey}
\alias{quantile.Tukey}
\title{Determine quantiles of a Tukey distribution}
\usage{
\method{quantile}{Tukey}(d, p, ...)
}
\arguments{
\item{d}{A \code{Tukey} distribution created by a call to \code{\link[=Tukey]{Tukey()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
Determine quantiles of a Tukey distribution
}
\examples{

set.seed(27)

X <- Tukey(4L, 16L, 2L)
X

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Tukey distribution: \code{\link{cdf.Tukey}}
}
\concept{Tukey distribution}
