% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_matdistribution.R
\name{plot.Matdist}
\alias{plot.Matdist}
\title{Plotting Distribution Functions for a Matrix Distribution}
\usage{
\method{plot}{Matdist}(x, fun = c("pdf", "cdf", "survival", "hazard", "cumhazard"), ...)
}
\arguments{
\item{x}{\link{Matdist}.}

\item{fun}{function to plot, one of: "pdf","cdf", "survival", "hazard", "cumhazard".}

\item{...}{Other parameters passed to \link{matplot}.}
}
\description{
Helper function to more easily plot a \link{Matdist}.
}
\details{
Essentially just a wrapper around \link{matplot}.
}
\examples{
\dontrun{
pdf <- runif(200)
mat <- matrix(pdf, 20, 10)
mat <- t(apply(mat, 1, function(x) x / sum(x)))
colnames(mat) <- 1:10
d <- as.Distribution(mat, fun = "pdf")
plot(d, "pdf", xlab = "x", ylab = "p(x)")
plot(d, "cdf", xlab = "x", ylab = "F(x)")
plot(d, "survival", xlab = "x", ylab = "S(x)")
plot(d, "hazard", xlab = "x", ylab = "h(x)")
plot(d, "cumhazard", xlab = "x", ylab = "H(x)")
}
}
\seealso{
\link{plot.Distribution} \link{plot.VectorDistribution}
}
