% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalPNorm.R
\name{generalPNorm}
\alias{generalPNorm}
\title{Generalised P-Norm}
\usage{
generalPNorm(fun, p, lower, upper)
}
\arguments{
\item{fun}{function to calculate the p-norm of.}

\item{p}{the pth norm to calculate}

\item{lower}{lower bound for the integral}

\item{upper}{upper bound for the integral}
}
\value{
Returns a numeric value for the p norm of a function evaluated between given limits.
}
\description{
Calculate the p-norm of any function between given limits.
}
\details{
The p-norm of a function \eqn{f} is given by,
\deqn{(\int_S |f|^p d\mu)^{1/p}}
where \eqn{S} is the function support.

The p-norm is calculated numerically using the \code{integrate} function and therefore results
are approximate only.
}
\examples{
generalPNorm(Exponential$new()$pdf,2,0,10)

}
