% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distribution.R
\name{cdf}
\alias{cdf}
\title{Cumulative Distribution Function}
\usage{
cdf(object, x1, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)
}
\arguments{
\item{object}{Distribution.}

\item{x1}{vector of numerics to evaluate function at.}

\item{...}{additional arguments.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X \le x)} otherwise, \eqn{P(X > x)}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{simplify}{if TRUE (default) returns results in simplest form (vector or data.table) otherwise as data.table.}
}
\value{
Cumulative distribution funciton evaluated at given points as either a numeric if \code{simplify} is TRUE
or as a data.table.
}
\description{
Returns the cumulative distribution function for a distribution evaluated at a given
point.
}
\details{
The (lower tail) cumulative distribution function, \eqn{F_X}, is defined as
 \deqn{F_X(x) = P(X \le x)}
 If \code{lower.tail} is FALSE then \eqn{1 - F_X(x)} is returned, also known as the
 \code{\link{survival}} function.

If available a cdf will be returned without warning using an analytic expression. Otherwise,
if the distribution has not been decorated with \code{FunctionImputation}, \code{NULL} is returned.
To impute the cdf, use \code{decorate(distribution, FunctionImputation)}, this will provide a numeric
calculation for the cdf with warning.

Additional named arguments can be passed, which are required for composite distributions such as
\code{\link{ProductDistribution}} and \code{\link{ArrayDistribution}}.
}
\section{R6 Usage}{
 $cdf(x1, ..., lower.tail = TRUE, log.p = FALSE, simplify = TRUE)
}

\seealso{
\code{\link{pdf}}, \code{\link{quantile}}, \code{\link{rand}} for other statistical functions.
\code{\link{FunctionImputation}}, \code{\link{decorate}} for imputing missing functions.
}
