\name{Version Management}
\docType{methods}
\alias{isOldVersion}
\alias{isOldVersion-methods}
\alias{isOldVersion,ANY-method}
\alias{conv2NewVersion}
\alias{conv2NewVersion-methods}
\alias{conv2NewVersion,ANY-method}
\alias{conv2NewVersion,LatticeDistribution-method}
\title{ Methods for Version Management in Package `distr' }
\description{Version-Management-methods}
\usage{isOldVersion(object)
new.object <- conv2NewVersion(object)
\S4method{isOldVersion}{ANY}(object)
\S4method{conv2NewVersion}{ANY}(object)
\S4method{conv2NewVersion}{LatticeDistribution}(object)
}
\arguments{
  \item{object}{object of class  \code{"ANY"} (or subclasses)}
}
\details{
 From version 1.9 of this package on, class \code{"AbscontDistribution"} has an extra slot
 \code{gaps}. As the addition of new slots will probably happen again in the future development
 of our packages, we provide the following two help functions
 \code{isOldVersion} and \code{conv2NewVersion} to check whether the object was generated by an 
 older version of this package and to convert such an object to the new format, respectively. 
Also, the intermediate class \code{"LatticeDistribution"} is introduced at version 1.9
so that all subclasses of \code{"DiscreteDistribution"} like \code{"Binom"}, \code{"Nbinom"} etc,
now have an extra slot \code{lattice}. \code{conv2NewVersion} takes this up and provides
a particular method for signature \code{"LatticeDistribution"} which fills slot
\code{lattice} accordingly.

 \describe{
\item{isOldVersion}{\code{signature(object = "ANY")}: 
throws an error if \code{isClass(class(object))} is \code{FALSE}, i.e.; if
the class of \code{object} is no formal (S4) class. Else it checks whether
all slots of the actual class definition may be accessed and if so
returns \code{FALSE} and else \code{TRUE} and issues a warning.
 }
\item{conv2NewVersion}{\code{signature(object = "ANY")}: 
Generates a valid copy of \code{object} (according to the actual class definition), 
using the slots of \code{object} where possible and for the slots which are not yet
present in \code{object} (because it was generated by an older version of 
the class definition), it generates a prototype object of the class 
of \code{object} with \code{new(class(object))} and uses
the slot values of this prototype to fill the missing slots.
 }
\item{conv2NewVersion}{\code{signature(object = "LatticeDistribution")}: 
Generates a valid copy of \code{object} (according to the actual class definition,
i.e.; with a corresponding \code{lattice}-slot), by generating a new instance of
this object by \code{new(class(object), <list-of-parameters>}.
 }
}
}
\keyword{utilities}
\concept{version management}