\name{BinomParameter-class}
\docType{class}
\alias{BinomParameter-class}
\alias{initialize,BinomParameter-method}

\title{Class "BinomParameter"}
\description{ The parameter of a binomial distribution, used by Binom-class}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("BinomParameter", prob, size)}.
Usually an object of this class is not needed on its own, it is generated automatically when an object of the class Binom
is instantiated. 
}
\section{Slots}{
  \describe{
    \item{\code{prob}:}{Object of class \code{"numeric"}: the probability of a binomial distribution }
    \item{\code{size}:}{Object of class \code{"numeric"}: the size of a binomial distribution }
    \item{\code{name}:}{Object of class \code{"character"}: a name / comment for the parameters }
  }
}
\section{Extends}{
Class \code{"Parameter"}, directly.
}
\section{Methods}{
  \describe{
    \item{initialize}{\code{signature(.Object = "BinomParameter")}: initialize method }
    \item{prob}{\code{signature(object = "BinomParameter")}: returns the slot \code{prob} of the parameter of the
    distribution }
    \item{prob<-}{\code{signature(object = "BinomParameter")}: modifies the slot \code{prob} of the parameter of the
    distribution }
    \item{size}{\code{signature(object = "BinomParameter")}: returns the slot \code{size} of the parameter of the distribution }
    \item{size<-}{\code{signature(object = "BinomParameter")}: modifies the slot \code{size} of the parameter of the distribution}
  }
}

\author{Thomas Stabla \email{Thomas.Stabla@uni-bayreuth.de},\cr Florian Camphausen \email{Florian.Camphausen@uni-bayreuth.de},\cr
 Peter Ruckdeschel \email{Peter.Ruckdeschel@uni-bayreuth.de},\cr Matthias Kohl \email{Matthias.Kohl@uni-bayreuth.de}}

\seealso{
\code{\link{Binom-class}}
\code{\link{DiscreteParameter-class}}
}

\examples{
W=new("BinomParameter",prob=0.5,size=1)
size(W) # size of this distribution is 1.
size(W)=2 # size of this distribution is now 2.
}
\keyword{}
