% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{set.grid.points}
\alias{set.grid.points}
\title{Sets grid points used for plotting PDP and ICE plots}
\usage{
set.grid.points(object, feature, values)
}
\arguments{
\item{object}{The Interpreter class that we want to modify the grid points of.}

\item{feature}{The name of the feature to set grid points for.}

\item{values}{The set of new values to be used as the grid points for the selected feature.
Must be a vector with entries in the range of the feature values in the training set
and must match the type of the given feature (either a vector of factor levels
or a vector of continuous feature values). Note that the center must be within
the range of new grid points for continuous features.}
}
\description{
Method for setting grid points for a specific feature plot
}
\note{
Because the grid points determine what calculations are performed for the
PDP/ICE functions, changing the grid points will remove any of the previously
calculated values in the 'Interpreter' object. For any 1-D ICE
or PDP plot, it will remove the previous calculations for the given feature. For any 2-D PDP
calcuations, it will remove plots that include the given feature as any of its features.
Note that these set grid points only apply to PDP and ICE plots, and ALE plots have their
own grid points determined by the distribution of the training data.
}
