% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.dispRity.R
\name{print.dispRity}
\alias{print.dispRity}
\title{Prints a \code{dispRity} object.}
\usage{
\method{print}{dispRity}(x, all = FALSE, ...)
}
\arguments{
\item{x}{A \code{dispRity} object.}

\item{all}{\code{logical}; whether to display the entire object (\code{TRUE}) or just summarise its contents (\code{FALSE} - default).}

\item{...}{further arguments to be passed to \code{print} or to \code{print.dispRity}.}
}
\description{
Summarises the content of a \code{dispRity} object.
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## Displaying the summary of the object content
disparity
print(disparity) # the same
print.dispRity(disparity) # the same

## Displaying the full object
print.dispRity(disparity, all = TRUE)

}
\seealso{
\code{\link{custom.subsets}}, \code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity}}.
}
\author{
Thomas Guillerme
}
