% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{extinction.subsets}
\alias{extinction.subsets}
\title{Getting the time subsets from at and after an extinction event}
\usage{
extinction.subsets(data, extinction, lag = 1, names = FALSE, as.list = FALSE)
}
\arguments{
\item{data}{a \code{dispRity} object.}

\item{extinction}{\code{numerical}, the time at the extinction event.}

\item{lag}{\code{numerical}, the lag effect (i.e. how many subsets after the extinction to consider - default = \code{1}).}

\item{names}{\code{logical}, whether to display the bins names (\code{TRUE}) or not (\code{FALSE} - default).}

\item{as.list}{\code{logical}, whether to output the results as a list for \code{\link{test.dispRity}} (\code{TRUE}) or not (\code{FALSE} - default).}
}
\description{
Getting the reference (pre-extinction) and the comparison (post-extinction) time subsets
}
\examples{
## Loading some disparity data
data(disparity)

## Time subsets for the K-Pg extinction (66 Mya)
extinction.subsets(disparity, 66, names = TRUE)

## Extinction with a lag effect of 3 slices
extinction_time <- extinction.subsets(disparity, 66, lag = 3, as.list = TRUE)

## Testing the extinction effect with a lag
test.dispRity(disparity, wilcox.test, comparisons = extinction_time,
              correction = "bonferroni")

}
\seealso{
\code{\link{chrono.subsets}}, \code{\link{test.dispRity}}
}
\author{
Thomas Guillerme
}
