% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shard.r
\name{shard}
\alias{shard}
\alias{distribute}
\title{Shard a data.frame/data.table or disk.frame into chunk and saves it into a disk.frame}
\usage{
shard(
  df,
  shardby,
  outdir = tempfile(fileext = ".df"),
  ...,
  nchunks = recommend_nchunks(df),
  overwrite = FALSE
)

distribute(...)
}
\arguments{
\item{df}{A data.frame/data.table or disk.frame. If disk.frame, then rechunk(df, ...) is run}

\item{shardby}{The column(s) to shard the data by.}

\item{outdir}{The output directory of the disk.frame}

\item{...}{not used}

\item{nchunks}{The number of chunks}

\item{overwrite}{If TRUE then the chunks are overwritten}
}
\description{
Shard a data.frame/data.table or disk.frame into chunk and saves it into a disk.frame

`distribute` is an alias for `shard`
}
\examples{

# shard the cars data.frame by speed so that rows with the same speed are in the same chunk
iris.df = shard(iris, "Species")

# clean up cars.df
delete(iris.df)
}
