% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_fit.R
\name{estimate}
\alias{estimate}
\alias{estimate,market_model-method}
\alias{estimate,equilibrium_model-method}
\title{Model estimation.}
\usage{
estimate(object, ...)

\S4method{estimate}{market_model}(
  object,
  gradient = "calculated",
  hessian = "calculated",
  standard_errors = "homoscedastic",
  ...
)

\S4method{estimate}{equilibrium_model}(object, method = "BFGS", ...)
}
\arguments{
\item{object}{A model object.}

\item{...}{Named parameter used in the model's estimation. These are passed further
down to the estimation call. For the \code{\linkS4class{equilibrium_model}} model, the
parameters are passed to \code{\link[systemfit]{systemfit}}, if the method is set to
\code{2SLS}, or to \code{\link[bbmle]{mle2}} for any other method. For the rest of
the models, the parameters are passed to \code{\link[bbmle]{mle2}}.}

\item{gradient}{One of two potential options: \code{"numerical"} and
\code{"calculated"}. By default, all the models are estimated using the
analytic expressions of their likelihoods' gradients.}

\item{hessian}{One of three potential options: \code{"skip"},
\code{"numerical"}, and \code{"calculated"}. The default is to use the
\code{"calculated"} Hessian for the model that expressions are
available and the \code{"numerical"} Hessian in other cases. Calculated
Hessian expressions are available for the basic and directional models.}

\item{standard_errors}{One of three potential options:
\code{"homoscedastic"}, \code{"heteroscedastic"}, or a vector with
variables names for which standard error clusters are to be created. The
default value is \code{"homoscedastic"}. If the option
\code{"heteroscedastic"} is passed, the variance-covariance matrix is
calculated using heteroscedasticity adjusted (Huber-White) standard errors.
If the vector is supplied, the variance-covariance matrix is calculated by
grouping the score matrix based on the passed variables.}

\item{method}{A string specifying the estimation method. When the passed value is
among \code{Nelder-Mead}, \code{BFGS}, \code{CG}, \code{L-BFGS-B}, \code{SANN},
and \code{Brent}, the model is estimated using
full information maximum likelihood based on \code{\link[bbmle]{mle2}} functionality.
When \code{2SLS} is supplied, the model is estimated using two-stage least squares
based on \code{\link[systemfit]{systemfit}}. In this case, the function returns a
list containing the first and second stage estimates. The default value is
\code{BFGS}.}
}
\value{
The object that holds the estimation result.
}
\description{
All models are estimated using full information maximum likelihood. The
\code{\linkS4class{equilibrium_model}} can also be estimated using two-stage
least squares. The maximum likelihood estimation is based on
\code{\link[bbmle]{mle2}}. If no starting values are provided, the function uses
linear regression estimates as initializing values. The default optimization method is
BFGS. For other alternatives see \code{\link[bbmle]{mle2}}. The implementation of
the two-stage least square estimation of the \code{\linkS4class{equilibrium_model}}
is based on \code{\link[systemfit]{systemfit}}.
}
\section{Functions}{
\itemize{
\item \code{estimate,market_model-method}: Full information maximum likelihood estimation.

\item \code{estimate,equilibrium_model-method}: Equilibrium model estimation.
}}

\examples{
\donttest{
# initialize the model using the houses dataset
model <- new(
  "diseq_deterministic_adjustment", # model type
  subject = ID, time = TREND, quantity = HS, price = RM,
  demand = RM + TREND + W + CSHS + L1RM + L2RM + MONTH,
  supply = RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(), # data
  correlated_shocks = FALSE # let shocks be independent
)

# estimate the model object (BFGS is used by default)
fit <- estimate(model)

# estimate the model by specifying the optimization details passed to the optimizer.
fit <- estimate(model, control = list(maxit = 1e+6))

# summarize results
summary(fit)
}
}
