% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disequilibrium_model.R,
%   R/diseq_stochastic_adjustment.R
\name{shortage_analysis}
\alias{shortage_analysis}
\alias{shortages}
\alias{normalized_shortages}
\alias{relative_shortages}
\alias{shortage_probabilities}
\alias{shortage_indicators}
\alias{shortage_standard_deviation}
\alias{shortages,disequilibrium_model-method}
\alias{normalized_shortages,disequilibrium_model-method}
\alias{relative_shortages,disequilibrium_model-method}
\alias{shortage_probabilities,disequilibrium_model-method}
\alias{shortage_indicators,disequilibrium_model-method}
\alias{shortage_standard_deviation,disequilibrium_model-method}
\alias{shortage_standard_deviation,diseq_stochastic_adjustment-method}
\title{Analysis of shortages}
\usage{
shortages(object, parameters)

normalized_shortages(object, parameters)

relative_shortages(object, parameters)

shortage_probabilities(object, parameters)

shortage_indicators(object, parameters)

shortage_standard_deviation(object, parameters)

\S4method{shortages}{disequilibrium_model}(object, parameters)

\S4method{normalized_shortages}{disequilibrium_model}(object, parameters)

\S4method{relative_shortages}{disequilibrium_model}(object, parameters)

\S4method{shortage_probabilities}{disequilibrium_model}(object, parameters)

\S4method{shortage_indicators}{disequilibrium_model}(object, parameters)

\S4method{shortage_standard_deviation}{disequilibrium_model}(object, parameters)

\S4method{shortage_standard_deviation}{diseq_stochastic_adjustment}(object, parameters)
}
\arguments{
\item{object}{A disequilibrium model object.}

\item{parameters}{A vector of parameters at which the shortages are evaluated.}
}
\value{
A vector with the (modified) shortages.
}
\description{
Analysis of shortages
}
\details{
The following methods offer functionality for analyzing estimated shortages
in the disequilibrium models.

\subsection{shortages}{
Returns the predicted shortages at a given point.
}

\subsection{normalized_shortages}{
Returns the shortages normalized by the variance of the difference of the shocks at a
given point.
}

\subsection{relative_shortages}{
Returns the shortages normalized by the supplied quantity at a given point.
}

\subsection{shortage_probabilities}{
Returns the shortage probabilities, i.e. the probabilities of an
observation coming from an excess demand regime, at the given point.
}

\subsection{shortage_indicators}{
Returns a vector of indicators (Boolean values) for each observation. An element of
the vector is TRUE for observations at which the estimated shortages are
non-negative, i.e. the market at in an excess demand state. The remaining elements
are FALSE. The evaluation of the shortages is performed using the passed parameter
vector.
}

\subsection{shortage_standard_deviation}{
Returns the variance of excess demand.
}
}
\section{Functions}{
\itemize{
\item \code{shortages}: Shortages.

\item \code{normalized_shortages}: Normalized shortages.

\item \code{relative_shortages}: Relative shortages.

\item \code{shortage_probabilities}: Shortage probabilities.

\item \code{shortage_indicators}: Shortage indicators.

\item \code{shortage_standard_deviation}: Shortage variance.
}}

\examples{
\donttest{
# initialize the model using the houses dataset
model <- new(
  "diseq_deterministic_adjustment", # model type
  c("ID", "TREND"), "TREND", "HS", "RM", # keys, time, quantity, and price variables
  "RM + TREND + W + CSHS + L1RM + L2RM + MONTH", # demand specification
  "RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH", # supply specification
  fair_houses(), # data
  correlated_shocks = FALSE # allow shocks to be correlated
)

# estimate the model object (BFGS is used by default)
est <- estimate(model, control = list(maxit = 1e+5))

# get estimated normalized shortages
head(normalized_shortages(model, est@coef))

# get estimated relative shortages
head(relative_shortages(model, est@coef))

# get the estimated shortage probabilities
head(shortage_probabilities(model, est@coef))

# get the estimated shortage indicators
head(shortage_indicators(model, est@coef))

# get the estimated shortages
head(shortages(model, est@coef))

# get the estimated shortage variance
shortage_standard_deviation(model, est@coef)
}
}
