% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseq_base.R
\name{get_mean_marginal_effect}
\alias{get_mean_marginal_effect}
\alias{get_mean_marginal_effect,diseq_base-method}
\title{Mean marginal effects}
\usage{
get_mean_marginal_effect(object, estimation, variable)

\S4method{get_mean_marginal_effect}{diseq_base}(object, estimation, variable)
}
\arguments{
\item{object}{A disequilibrium model object.}

\item{estimation}{A model estimation object (i.e. a \code{\link[bbmle]{mle2}} object).}

\item{variable}{Variable name for which the effect is calculated.}
}
\value{
The mean of the estimated marginal effects of the passed variable.
}
\description{
Returns the average estimated marginal effect a variable.
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_basic", 500, 3, # model type, observed entities, observed time points
  -0.9, 8.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(-0.05, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "diseq_basic", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  use_correlated_shocks = TRUE # allow shocks to be correlated
)

# estimate a model object
est <- estimate(model)

# get the mean marginal effects of variable "X1"
get_mean_marginal_effect(model, est, "X1")
}
}
