% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_simulation.R
\name{simulate_model_data}
\alias{simulate_model_data}
\alias{simulate_model_data,ANY-method}
\title{Simulate model data.}
\usage{
simulate_model_data(
  model_string,
  nobs,
  tobs,
  alpha_d,
  beta_d0,
  beta_d,
  eta_d,
  alpha_s,
  beta_s0,
  beta_s,
  eta_s,
  gamma,
  beta_p0,
  beta_p,
  sigma_d = 1,
  sigma_s = 1,
  sigma_p = 1,
  rho_ds = 0,
  rho_dp = 0,
  rho_sp = 0,
  seed = NA_integer_,
  price_generator = function(nobs) stats::rnorm(n = nobs, mean = 2.5, sd = 0.5),
  control_generator = function(nobs) stats::rnorm(n = nobs, mean = 2.5, sd = 0.5)
)

\S4method{simulate_model_data}{ANY}(
  model_string,
  nobs,
  tobs,
  alpha_d,
  beta_d0,
  beta_d,
  eta_d,
  alpha_s,
  beta_s0,
  beta_s,
  eta_s,
  gamma,
  beta_p0,
  beta_p,
  sigma_d = 1,
  sigma_s = 1,
  sigma_p = 1,
  rho_ds = 0,
  rho_dp = 0,
  rho_sp = 0,
  seed = NA_integer_,
  price_generator = function(nobs) stats::rnorm(n = nobs, mean = 2.5, sd = 0.5),
  control_generator = function(nobs) stats::rnorm(n = nobs, mean = 2.5, sd = 0.5)
)
}
\arguments{
\item{model_string}{Model type. It should be among \code{eq_2sls}, \code{eq_fiml},
\code{diseq_basic}, \code{diseq_directional}, \code{diseq_deterministic_adjustment}, and
\code{diseq_stochastic_adjustment}.}

\item{nobs}{Number of simulated entities.}

\item{tobs}{Number of simulated dates.}

\item{alpha_d}{Price coefficient of demand.}

\item{beta_d0}{Constant coefficient of demand.}

\item{beta_d}{Coefficients of exclusive demand controls.}

\item{eta_d}{Demand coefficients of common controls.}

\item{alpha_s}{Price coefficient of supply.}

\item{beta_s0}{Constant coefficient of supply.}

\item{beta_s}{Coefficients of exclusive supply controls.}

\item{eta_s}{Supply coefficients of common controls.}

\item{gamma}{Price equation's stability factor.}

\item{beta_p0}{Price equation's constant coefficient.}

\item{beta_p}{Price equation's control coefficients.}

\item{sigma_d}{Demand shock's standard deviation.}

\item{sigma_s}{Supply shock's standard deviation.}

\item{sigma_p}{Price equation shock's standard deviation.}

\item{rho_ds}{Demand and supply shocks' correlation coefficient.}

\item{rho_dp}{Demand and price shocks' correlation coefficient.}

\item{rho_sp}{Supply and price shocks' correlation coefficient.}

\item{seed}{Pseudo random number generator seed.}

\item{price_generator}{Pseudo random number generator callback for prices.}

\item{control_generator}{Pseudo random number generator callback for non-price controls.}
}
\value{
The simulated data.
}
\description{
Returns a data \code{tibble} with simulated data from a generating process that matches the
passed model string. By default, the simulated observations of the controls are drawn from a
normal distribution.
}
