% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightsKM.R
\name{weightsKM}
\alias{weightsKM}
\title{Inverse probability of censoring weights}
\usage{
weightsKM(y, delta)
}
\arguments{
\item{y}{numerical vector with right-censored follow-up times}

\item{delta}{numerical vector, same length as y, 1 indicates an event while 0 indicates censoring}
}
\value{
A data frame with 2 coloumns. The first column consists of usual inverse probability of censoring weights. For the second column, IPC weights modified in a redistribute-to-the-right approach are given.
}
\description{
Computes inverse probability of censoring weights.
}
\details{
Inverse probability of censoring weights are calculated by dividing the event indicator by the Kaplan-Meier estimator of the censoring time.
This leads to zero weights for censored observations, while every uncensored event receives a weight larger than 1, representing several censored observations.
In the redistribute-to-the-right approach, the last observation always receives a positive weight such that no weight will be lost.
Further details can be found in Seipp et al. (2021).
}
\examples{
data(colcancer)
kw <- weightsKM(colcancer$logfollowup, colcancer$death)
}
\references{
Seipp, A., Uslar, V., Weyhe, D., Timmer, A., & Otto-Sobotka, F. (2021). Weighted expectile regression for right-censored data. Statistics in Medicine, 40(25), 5501-5520.
}
