% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet_process_hierarchical_mvnormal2.R
\name{DirichletProcessHierarchicalMvnormal2}
\alias{DirichletProcessHierarchicalMvnormal2}
\title{Create a Hierarchical Dirichlet Mixture of
semi-conjugate Multivariate Normal Distributions}
\usage{
DirichletProcessHierarchicalMvnormal2(dataList, g0Priors,
  gammaPriors = c(2, 4), alphaPriors = c(2, 4), numSticks = 50,
  numInitialClusters = 1, mhDraws = 250)
}
\arguments{
\item{dataList}{List of data for each separate Dirichlet mixture object}

\item{g0Priors}{Prior Parameters for the top level base distribution.}

\item{gammaPriors}{Prior parameters for the top level concentration parameter.}

\item{alphaPriors}{Prior parameters for the individual parameters.}

\item{numSticks}{Truncation level for the Stick Breaking formulation.}

\item{numInitialClusters}{Number of clusters to initialise with.}

\item{mhDraws}{Number of Metropolis-Hastings samples to perform for each cluster update.}
}
\value{
dpobjlist A Hierarchical Dirichlet Process object that can be fitted, plotted etc.
}
\description{
Create a Hierarchical Dirichlet Mixture of
semi-conjugate Multivariate Normal Distributions
}
