% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mca.R
\docType{methods}
\name{mca}
\alias{mca}
\alias{mca-method}
\alias{mca,data.frame-method}
\alias{mca,matrix-method}
\title{Multiple Correspondence Analysis}
\usage{
mca(object, ...)

\S4method{mca}{data.frame}(object, rank = NULL, sup_row = NULL, sup_col = NULL, sup_quanti = NULL)

\S4method{mca}{matrix}(object, rank = NULL, sup_row = NULL, sup_col = NULL)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} numeric \code{\link{matrix}} or a
\code{\link{data.frame}}.}

\item{...}{Currently not used.}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of
components to be kept in the results. If \code{NULL} (the default),
\eqn{min(m, p) - 1} components will be returned.}

\item{sup_row}{A \code{vector} specifying the indices of the supplementary rows.}

\item{sup_col}{A \code{vector} specifying the indices of the supplementary
categorical columns.}

\item{sup_quanti}{A \code{vector} specifying the indices of the supplementary
quantitative columns.}
}
\value{
A \code{\linkS4class{MCA}} object.
}
\description{
Computes a multiple correspondence analysis.
}
\references{
Lebart, L., Piron, M. and Morineau, A. \emph{Statistique exploratoire
multidimensionnelle: visualisation et inférence en fouille de données}.
Paris: Dunod, 2006.
}
\seealso{
\code{\link[=svd]{svd()}}, \code{\link[=cdt]{cdt()}}

Other multivariate analysis: 
\code{\link{ca}()},
\code{\link{pca}()},
\code{\link{pcoa}()},
\code{\link{predict}()}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
