% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lma_functions.R
\name{lma}
\alias{lma}
\title{Generate a suite of leaf mass per area results}
\usage{
lma(specimen_data)
}
\arguments{
\item{specimen_data}{A table that must include "Site", "Morphotype", and
either "Petiole Metric", or "Blade Area", "Petiole Area", and "Petiole Width".}
}
\value{
A list of tables containing leaf mass per area reconstructions.
\itemize{
\item species_mean_lma contains the average LMA for each morphospecies-site pair.
Values calculated using the regression from Royer et al. (2007).
\item royer_site_mean_lma contains the average LMA for each site. Values calculated
using the regression from Royer et al. (2007)
\item lowe_site_lma contains the average LMA for each site. Values calculated using
the regression from Lowe et al. (2024)
\item lowe_variance contains the variance in LMA for each site. Values calculated
using the regression from Lowe et al. (2024)
}
}
\description{
\code{lma()} takes either raw or processed leaf physiognomic data and returns
leaf mass per area (LMA) reconstructions of species-mean, site-mean, and site-
variance.

\code{lma()} calls \code{\link[=calc_lma]{calc_lma()}} multiple times with different sets of
parameters.  See \code{\link[=calc_lma]{calc_lma()}} for more control over LMA reconstructions.
}
\examples{
results <- lma(McAbeeExample)
results
}
\references{
\itemize{
\item Royer, D. L., L. Sack, P. Wilf, C. H. Lusk, G. J. Jordan, Ulo Niinemets, I. J. Wright, et al. 2007. Fossil Leaf Economics Quantified: Calibration, Eocene Case Study, and Implications. Paleobiology 33: 574–589
\item Lowe, A. J., D. L. Royer, D. J. Wieczynski, M. J. Butrim, T. Reichgelt, L. Azevedo-Schmidt, D. J. Peppe, et al. 2024. Global patterns in community-scale leaf mass per area distributions of woody non-monocot angiosperms and their utility in the fossil record. In review.
}
}
