% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_tdv_grdtp.R
\name{partition_tdv_grdtp}
\alias{partition_tdv_grdtp}
\title{Obtain a partition using a Greedy-type algorithm}
\usage{
partition_tdv_grdtp(m_bin, k, verify = TRUE)
}
\arguments{
\item{m_bin}{A matrix. A phytosociological table of 0s (absences) and 1s
(presences), where rows correspond to taxa and columns correspond to
relevés.}

\item{k}{A numeric giving the number of desired groups.}

\item{verify}{A logical. If \code{TRUE} (the default) the function verifies if
basic features of \code{m_bin} data structure are met. Otherwise if \code{FALSE}.}
}
\value{
A numeric vector, which length is the same as the number of columns
of \code{m_bin}, with numbers from 1 to \code{k}, representing the group to which the
respective column was ascribed.
}
\description{
This function obtains a partition of the columns of a given phytosociological
matrix, aiming at high values of the Total Differential Value (TDV),
implementing a Greedy-type algorithm.
}
\details{
Given the phytosociological table \code{m_bin} (rows corresponding to
taxa and columns corresponding to relevés), this function uses a
Greedy-type algorithm (a simplified version of the Greedy algorithm) to
obtain a \code{k}-partition (\code{k}, defined by the user) of the columns of
\code{m_bin}, aiming at high values of TDV.
The algorithm operates in the following way: Firstly, \code{k} columns are
selected randomly to work as seeds for each one of the desired \code{k} groups.
Secondly, one of the remaining columns is selected randomly and added to
the partition group which maximizes the upcoming TDV. This second step is
repeated until all columns are placed in a group of the \code{k}-partition.

This function is expected to perform faster than \code{\link[=partition_tdv_grasp]{partition_tdv_grasp()}},
yet returning worse partitions in terms of TDV. For the (true) Greedy
algorithm see \code{\link[=partition_tdv_grasp]{partition_tdv_grasp()}}.
See \code{\link[=tdv]{tdv()}} for an explanation on the TDV of a phytosociological table.
}
\examples{
# Getting the Taxus baccata forests data set
data(taxus_bin)

# Obtaining a partiton based on a Greedy-type algorithm
partition_tdv_grdtp(taxus_bin, 3)

}
\author{
Jorge Orestes Cerdeira and Tiago Monteiro-Henriques.
E-mail: \email{tmh.dev@icloud.com}.
}
