% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_diff_prob_matrix.R
\name{get_diffusion_probability_matrix}
\alias{get_diffusion_probability_matrix}
\alias{getDiffusionProbabilityMatrix}
\alias{get_diffu_Pt}
\title{Diffusion Probability Matrix}
\usage{
get_diffusion_probability_matrix(
  g,
  tau,
  type = "Normalized Laplacian",
  weights = NULL,
  verbose = TRUE
)

getDiffusionProbabilityMatrix(g, tau, type = "Normalized Laplacian", weights = NULL,
                                     verbose = TRUE)

get_diffu_Pt(
  g,
  tau,
  type = "Normalized Laplacian",
  weights = NULL,
  verbose = TRUE
)
}
\arguments{
\item{g}{a single-layer network}

\item{tau}{diffusion time}

\item{type}{default "Normalized Laplacian". The type of Laplacian (i.e. of
dynamics) to consider. Other types available are:
\describe{
  \item{Laplacian}{for the classical combinatorial Laplacian matrix;
    it governs the diffusion dynamics on the network}
  \item{Normalized Laplacian}{for the Laplacian matrix normalized by degree
    matrix, the so-called classical random walk normalized Laplacian;
    it governs stochastic walks on the network}
  \item{Quantum Laplacian}{for the Laplacian matrix normalized to be
    symmetric; it governs quantum walks on the network}
  \item{MERW normalized Laplacian}{the maximal-entropy random walk (RW)
    normalized Laplacian; it governs stochastic walks on the network,
    in which the random walker moves according to a maximal-entropy RW [1].}
}
Note that you can type abbreviations, e.g. "L", "N", "Q", "M" for the
respective types (case is ignored). The argument match is done through
\code{\link[strex]{match_arg}}.}

\item{weights}{edge weights, representing the strength/intensity (not the cost!) of each link.
if weights is NULL (the default) and g has an edge attribute called weight, then
it will be used automatically.
If this is NA then no weights are used (even if the graph has a weight attribute).}

\item{verbose}{default \code{TRUE}. If information on the type of Laplacian
or on edge weights should be printed.}
}
\value{
The matrix \eqn{exp^{-\tau L}}, exponential of a Laplacian matrix.
}
\description{
Returns a matrix where each entry encodes the diffusion probability between two nodes
}
\section{Functions}{
\itemize{
\item \code{getDiffusionProbabilityMatrix()}: Old deprecated function

}}
\references{
De Domenico, M. (2017). Diffusion Geometry Unravels the Emergence of
  Functional Clusters in Collective Phenomena. Physical Review Letters.
  \doi{10.1103/PhysRevLett.118.168301}

  Bertagnolli, G., & De Domenico, M. (2021). Diffusion geometry of multiplex and
  interdependent systems. Physical Review E, 103(4), 042301.
  \doi{10.1103/PhysRevE.103.042301}
  \href{https://arxiv.org/abs/2006.13032}{arXiv: 2006.13032}
}
\seealso{
\code{\link{get_laplacian}, \link{get_distance_matrix}}
}
\keyword{Markov-chain}
\keyword{probabilities}
\keyword{transition}
