% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\docType{methods}
\name{[<-,PaletteOfStyles-method}
\alias{[,PaletteOfStyles,ANY,ANY,ANY-method}
\alias{[<-,PaletteOfStyles-method}
\alias{[[,PaletteOfStyles-method}
\title{Extract/Replace a Style Class or Object from PaletteOfStyles}
\usage{
\S4method{[}{PaletteOfStyles}(x, i, j, ...) <- value

\S4method{[}{PaletteOfStyles,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[[}{PaletteOfStyles}(x, i, j, ..., exact = TRUE)
}
\arguments{
\item{x}{a \code{\link{PaletteOfStyles}} object}

\item{i}{numeric, or character corresponding to a valid style \code{format}}

\item{j}{numeric, or character corresponding to a valid style
\code{brightness}}

\item{...}{pass a numeric or character corresponding to a valid
\code{color.mode}}

\item{value}{a \emph{list} of \code{\link{Style}} class or
\code{\link{Style}} objects}

\item{drop}{TRUE or FALSE, whether to drop dimensions, defaults to FALSE,
which is different than generic}

\item{exact}{passed on to generic}
}
\value{
a \code{\link{Style}} \code{ClassRepresentation} object or
   \code{\link{Style}} object for \code{[[}, and a list of the same for
   \code{[}
}
\description{
Extract/Replace a Style Class or Object from PaletteOfStyles
}
\examples{
pal <- PaletteOfStyles()
pal[["ansi256", "light", "rgb"]]
pal["ansi256", "light", ]
pal["ansi256", "light", "rgb"] <- list(StyleAnsi8NeutralRgb())
}
\seealso{
\code{\link{diffPrint}} for explanations of \code{format},
  \code{brightness}, and \code{color.mode}
}

