% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdiff.R
\name{Rdiff_chr}
\alias{Rdiff_chr}
\alias{Rdiff_obj}
\title{Run Rdiff Directly on R Objects}
\usage{
Rdiff_chr(from, to, silent = FALSE, minimal = FALSE, nullPointers = TRUE)

Rdiff_obj(from, to, silent = FALSE, minimal = FALSE, nullPointers = TRUE)
}
\arguments{
\item{from}{character or object coercible to character for \code{Rdiff_chr},
any R object with \code{Rdiff_obj}, or a file pointing to an RDS object}

\item{to}{character same as \code{from}}

\item{silent}{TRUE or FALSE, whether to display output to screen}

\item{minimal}{TRUE or FALSE, whether to exclude the lines that show the
actual differences or only the actual edit script commands}

\item{nullPointers}{passed to \code{tools::Rdiff}}
}
\value{
the Rdiff output, invisibly if \code{silent} is FALSE
Rdiff_chr(letters[1:5], LETTERS[1:5])
Rdiff_obj(letters[1:5], LETTERS[1:5])
}
\description{
These functions are here for reference and testing purposes.  They are
wrappers to \code{tools::Rdiff} and rely on an existing system diff utility.
You should be using \code{\link{ses}} or \code{\link{diffChr}} instead of
\code{Rdiff_chr} and \code{\link{diffPrint}} instead of \code{Rdiff_obj}.
See limitations in note.
}
\details{
\code{Rdiff_chr} runs diffs on character vectors or objects coerced to
character vectors, where each value in the vectors is treated as a line in a
file.  \code{Rdiff_chr} always runs with the \code{useDiff} and \code{Log}
parameters set to \code{TRUE}.

\code{Rdiff_obj} runs diffs on the \code{print}ed representation of
the provided objects.  For each of \code{from}, \code{to}, will check if they
are 1 length character vectors referencing an RDS file, and will use the
contents of that RDS file as the object to compare.
}
\note{
These functions will try to use the system \code{diff} utility. This
  will fail in systems that do not have that utility available (e.g. windows
  installation without Rtools).
}
\seealso{
\code{\link{ses}}, \code{\link[=diffPrint]{diff*}}
}
