\name{plot.diffee}
\alias{plot.diffee}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plotting functions for displaying the differential network generated by the diffee algorithm
}
\description{
This function plots either the differential network or the neighborhood network for a certain node. Please run demo(diffeeDemo) to learn the basic functions provided by this package.  For further details, please read the original paper:   <arXiv:1710.11223>.
}
\usage{
  \method{plot}{diffee}(x, type="graph", index=NULL, ...)
}
\arguments{
  \item{x}{
    diffee object
  }
  \item{type}{
    Plotting type. This argument defines which type of network(s) to plot. There are four options:
    "graph": plot the network. T

    "neighbor": plot the neighborhood network for a given node.
  }
  \item{index}{
    If \code{type="neighbor"}, \code{index} indicates the row number of the node to be investigated. This function plots its neighborhood network in the differential network by diffee algorithm.
  }
  \item{...}{
    Additional arguments to pass to plot function
  }
}
\details{
  Plotting function for diffee object. It can be used to plot result obtained from running the diffee algorithm.
}
\references{
Beilun Wang, Arshdeep Sekhon, Yanjun Qi (2018). Fast and Scalable Learning of Sparse Changes in High-Dimensional Gaussian Graphical Model Structure. <arXiv:1710.11223>
}
\author{
  Beilun Wang and Yanjun Qi
}
\seealso{
  \code{\link{diffee}}
}
\examples{
data(exampleData)
results = diffee(C = exampleData[[1]], D =  exampleData[[2]], 0.05)
plot.diffee(results)
plot.diffee(results, type="neighbor", index=50)
}
\keyword{ diffee }
