% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR.R
\name{coef.difNLR}
\alias{coef.difNLR}
\alias{coefficients.difNLR}
\title{Extract model coefficients from an object of \code{"difNLR"} class.}
\usage{
\method{coef}{difNLR}(object, SE = FALSE, simplify = FALSE, ...)
}
\arguments{
\item{object}{an object of \code{"difNLR"} class.}

\item{SE}{logical: should the standard errors of estimated parameters be also returned? (default is \code{FALSE}).}

\item{simplify}{logical: should the estimated parameters be simplified to a matrix? (default is \code{FALSE}).}

\item{...}{other generic parameters for \code{predict()} function.}
}
\description{
S3 method for extracting model coefficients from an object of \code{"difNLR"} class.
}
\examples{
\dontrun{
# Loading data based on GMAT
data(GMAT)

Data <- GMAT[, 1:20]
group <- GMAT[, "group"]

# Testing both DIF effects using likelihood-ratio test and
# 3PL model with fixed guessing for groups
(x <- difNLR(Data, group, focal.name = 1, model = "3PLcg"))

# Coefficients
coef(x)
coef(x, SE = TRUE)
coef(x, SE = TRUE, simplify = TRUE)
}
}
\references{
Drabinova, A. & Martinkova, P. (2017). Detection of differential item functioning with nonlinear regression:
A non-IRT approach accounting for guessing. Journal of Educational Measurement, 54(4), 498--517,
\doi{10.1111/jedm.12158}.

Hladka, A. & Martinkova, P. (2020). difNLR: Generalized logistic regression models for DIF and DDF detection.
The R journal, 12(1), 300--323, \doi{10.32614/RJ-2020-014}.

Swaminathan, H. & Rogers, H. J. (1990). Detecting differential item functioning using logistic regression procedures.
Journal of Educational Measurement, 27(4), 361--370, \doi{10.1111/j.1745-3984.1990.tb00754.x}
}
\seealso{
\code{\link[difNLR]{difNLR}} for DIF detection among binary data using generalized logistic regression model. \cr
\code{\link[stats]{coef}} for generic function extracting model coefficients.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
