% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{read_10x}
\alias{read_10x}
\title{Read 10X counts data}
\usage{
read_10x(path, clip_end = TRUE, sep = ".")
}
\arguments{
\item{path}{The file path prefix to the raw 10X output directory}

\item{clip_end}{A logical indicating whether to remove the suffix "-N" 
from the barcodes, where N is n integer such as 1. The default it TRUE.}

\item{sep}{A character indicating the separator to use in the call 
to \code{\link[base]{make.unique}}.}
}
\value{
expr A sparse matrix of counts from 10X cell ranger
 with cells in the columns and genes in the rows.
}
\description{
Read the counts output from into a sparse matrix. 
Given a 10X output path, 
Read in the the output files from 10X CellRanger. Specifically, \code{path} 
should be be a directory containing the raw count output from 10X 
CellRnager with  output files \code{barcodes.tsv} 
\code{genes.tsv} \code{matrix.mtx}, or 
if using CellRanger v2, or \code{barcodes.tsv.gz} \code{features.tsv.gz} 
\code{matrix.mtx.gz} if using CellRanger v3. When reading in the barcodes 
and gene names, duplicates are removed with the make.unique function. 
The separator is specified by \code{sep} by default.
}
\examples{
\donttest{
dir <- "path/to/10x" # should show 3 files described above
counts <- read_10x(dir)
}
}
