% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_custom_domino_legends}
\alias{create_custom_domino_legends}
\title{Create custom legends for the domino plot}
\usage{
create_custom_domino_legends(
  contrast_levels,
  var_positions,
  var_id,
  contrast,
  logfc_colors,
  logfc_limits,
  color_scale_name,
  size_scale_name,
  min_dot_size,
  max_dot_size,
  legend_text_size = 8
)
}
\arguments{
\item{contrast_levels}{A character vector of contrast level names.}

\item{var_positions}{A data frame containing variable positions.}

\item{var_id}{A string representing the column name for the variable identifier.}

\item{contrast}{A string representing the column name for the contrast variable.}

\item{logfc_colors}{A named vector specifying the colors for the log fold change scale.}

\item{logfc_limits}{A numeric vector of length 2 specifying the limits for the log fold change color scale.}

\item{color_scale_name}{A string specifying the name of the color scale in the legend.}

\item{size_scale_name}{A string specifying the name of the size scale in the legend.}

\item{min_dot_size}{A numeric value indicating the minimum dot size.}

\item{max_dot_size}{A numeric value indicating the maximum dot size.}

\item{legend_text_size}{A numeric value indicating the text size for the legend.}
}
\value{
A ggplot object containing custom legends.
}
\description{
Create custom legends for the domino plot
}
\keyword{internal}
