% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clusters.R
\name{get_clusters}
\alias{get_clusters}
\title{Clustering groups returned as dataframe}
\usage{
get_clusters(dist_mat, cluster_num, method)
}
\arguments{
\item{dist_mat}{A distance matrix.}

\item{cluster_num}{Number of clusters.}

\item{method}{The agglomeration method that is passed to \code{\link[stats]{hclust}}. This can be chosen from the following: "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}
}
\value{
A map upon which dialect areas are clustered.

A dataframe with the two columns area and (clustering) grouping.
}
\description{
Input a distance matrix and returns a dataframe with two columns: area and clustering grouping, where a choice of clustering method is provided.
}
\examples{
# Example 1:
data(distDutch)
get_clusters(distDutch, 5 ,"ward.D2")
}
