% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_concordance.R
\name{get_concordance}
\alias{get_concordance}
\title{Retrieve Concordance for Words in Documents}
\usage{
get_concordance(pids, words, window = 20, limit = 10)
}
\arguments{
\item{pids}{A vector or data frame containing document IDs.}

\item{words}{A string of words (tokens) for which the concordance will be retrieved. For multiple tokens use keyword OR}

\item{window}{An optional numeric value specifying the number of characters before and after the matching word (default is 20).}

\item{limit}{An optional numeric value specifying the maximum number of results to return (default is 5000).}
}
\value{
A data frame containing the concordance results for each word in the specified documents. Returns NULL if the API request fails or no results are found.
}
\description{
This function obtains the concordance for specified words within given documents.
}
\examples{
document_ids <- c("URN:NBN:no-nb_digibok_2008051404065", "URN:NBN:no-nb_digibok_2010092120011")
tokens <- "Norge"
window <- 20
limit <- 1000
result <- get_concordance(document_ids, tokens, window, limit)
}
