% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oplike.R
\name{read_oplm_par}
\alias{read_oplm_par}
\title{Read item parameters from oplm PAR or CML files}
\usage{
read_oplm_par(par_path)
}
\arguments{
\item{par_path}{path to a file in the (binary) OPLM PAR format or the human readable CML format}
}
\value{
depends on the input. For .PAR files a tibble with columns: item_id, item_score, beta, nbr,
for .CML files also several statistics columns that are outputted by OPLM as part of the calibration.
}
\description{
Read item parameters from oplm PAR or CML files
}
\details{
It is occasionally useful to calibrate new items on an existing scale. This
function offers the possibility to read parameters from the proprietary oplm format 
so that they can be used to fix a new calibration in Dexter on an existing scale of items
that were calibrated in oplm.
}
\examples{
\dontrun{
\donttest{
par = read_oplm_par('/parameters.PAR')
f = fit_enorm(db, fixed_params=par)
}}
}
