% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{start_new_project}
\alias{start_new_project}
\title{Start a new project}
\usage{
start_new_project(rules, db = "dexter.db", covariates = NULL)
}
\arguments{
\item{rules}{A data frame with columns \code{item_id}, \code{response}, and \code{item_score}.
The order is not important but spelling is. Any other columns will be ignored.}

\item{db}{A connection to an existing sqlite database or a string specifying a filename
for a new sqlite database to be created. If this name does not
contain a path, the file will be created in the work
directory. Any existing file with the same name will be overwritten.}

\item{covariates}{An optional list of person covariates. Names should correspond to covariates intended to be used in the project.
Values are used as default (missing) values for these covariates. The datatype will also be inferred from the values.
Known covariates will be imported (if supplied) in \code{\link{add_booklet}}.}
}
\value{
If the scoring rules pass a sanity check, a handle to the data base.
Otherwise, a data frame listing the problems found, with 4 columns:
item_id: id of the problematic item
less_than_two_scores: if TRUE, the item has only one distinct score
duplicated_responses: if TRUE, the item contains two or more identical response categories
min_score_not_zero: if TRUE, the minimum score of the item was not 0
}
\description{
Imports a complete set of scoring rules and starts a new project (data base)
}
\details{
This package only works with closed items (e.g. likert, MC or possibly short answer): 
it does not score any open items.
The first step to creating a project is to import an exhaustive list of all items and
all admissible responses, along with the score that any of the latter will be given.
Responses may be integers or strings but they will always be treated as strings.
Scores must be integers, and the minimum score for an item must be 0.
When inputting data, all responses not specified in the rules can optionally be treated as
missing and ultimately scored 0, but it is good style to include the missing
responses in the list. NA values will be treated as the string 'NA'.
}
\examples{
\donttest{
head(verbAggrRules)
db = start_new_project(verbAggrRules, "verbAggression.db", 
  covariates=list(gender="<unknown>"))
}

}
