% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wang_82}
\alias{wang_82}
\title{Wang et al. equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}}
\source{
\url{http://en.cnki.com.cn}
}
\usage{
wang_82
}
\description{
Wang, R., Lan, Z. and Ding, Y. (1982) Studies on mathematical models of the relationship
between insect development and temperature. Acta Ecol. Sin, 2, 47-57.
}
\details{
Equation:
\deqn{rT = \frac{K}{1 + e^{-r*(T - T0)}} * (1 - e^{-\frac{T - TL}{aa}}) * (1 - e^{-\frac{TH - T}{aa}})}{%
      rT = (K / (1 + exp(-r*(T - T0)))) * (1 - exp(-(T - TL)/aa)) * (1 - exp(-(TH - T)/aa))}

where rT is the development rate, T the temperature, and K, r, T0, TH, and TL constants.
}
\keyword{datasets}
