% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_info.R
\name{devRatePlotInfo}
\alias{devRatePlotInfo}
\title{Plot parameter estimates from the literature}
\usage{
devRatePlotInfo(eq, sortBy = "genSp", stage = "all", ...)
}
\arguments{
\item{eq}{The name of the equation.}

\item{sortBy}{The filter to seperate species ("ordersp", "familysp, "genussp", "species", "genSp").}

\item{stage}{The life stage of the organism ("all", "eggs", "L1", "L2", "L3", "L4", "L5",
"larva", "pupa", "prepupa", "female", "male", ...)}

\item{...}{Aditional arguments for the plot.}
}
\value{
Nothing.
}
\description{
Plot parameter estimates from the literature
}
\examples{
devRatePlotInfo(eq = davidson_44, sortBy = "genSp", xlim = c(0,40), ylim = c(0,0.05))
devRatePlotInfo(eq = campbell_74, sortBy = "familysp", xlim = c(0,30), ylim = c(0,0.05))
devRatePlotInfo(eq = taylor_81, sortBy = "ordersp", xlim = c(-20,80), ylim = c(0,0.2))
}

