# Code for this function modified from package `codename` by Steven Miller under license GPL -2.

#' Display package version for \pkg{despair}
#'
#' @description \code{despair.message()} produces a message about the package version
#' and the version of R making use of this package.
#'
#' @return \code{despair.message()} returns a message about the install version
#' of \pkg{despair}.
#' @export
#'
#' @author JP Monteagudo
#'
#' @examples
#' despair.message()
#'
#'

despair.message <- function(){
  message(paste0("despair string generated by {despair} v.",
                 utils::packageVersion("despair"),".",
                 R.Version()$version.string,"."))
}
