% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desirability.R
\name{maximize}
\alias{maximize}
\alias{aliases}
\alias{minimize}
\alias{target}
\alias{constrain}
\alias{category}
\title{Aliases for individual desirability functions}
\usage{
maximize(x, low, high, scale = 1, missing = NA_real_, use_data = FALSE)

minimize(x, low, high, scale = 1, missing = NA_real_, use_data = FALSE)

target(
  x,
  low,
  target,
  high,
  scale_low = 1,
  scale_high = 1,
  missing = NA_real_,
  use_data = FALSE
)

constrain(x, low, high, missing = NA_real_, use_data = FALSE)

category(x, categories, missing = NA_real_)
}
\arguments{
\item{x}{A vector of data to compute the desirability function}

\item{low, high, target}{Single numeric values that define the active ranges of
desirability.}

\item{scale, scale_low, scale_high}{A single numeric value to rescale the
desirability function (each should be great than 0.0). Values >1.0 make the
desirability more difficult to satisfy while smaller values make it easier
(see the examples below). \code{scale_low} and  \code{scale_high} do the same for
target functions with \code{scale_low} affecting the range below the \code{target}
value and \code{scale_high} affecting values greater than \code{target}.}

\item{missing}{A single numeric value on \verb{[0, 1]} (or \code{NA_real_}) that
defines how missing values in \code{x} are mapped to the desirability score.}

\item{use_data}{Should the low, middle, and/or high values be derived from
the data (\code{x}) using the minimum, maximum, or median (respectively)?}

\item{categories}{A named vector of desirability values that match all
possible categories to specific desirability values. Data that are not
included in \code{categories} are given the value in \code{missing}.}
}
\description{
Aliases for individual desirability functions
}
\keyword{internal}
