% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-deseats_fc.R
\name{autoplot,deseats_fc-method}
\alias{autoplot,deseats_fc-method}
\title{\code{ggplot2} Plot Method for Class \code{"deseats_fc"}}
\usage{
\S4method{autoplot}{deseats_fc}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"deseats_fc"}, for example generated by a 
call to \code{\link{predict,s_semiarma-method}}.}

\item{...}{currently without use; implemented for compatibility.}
}
\value{
This method returns a \code{ggplot2} plot object, i.e. an object of classes 
\code{"gg"} and \code{"ggplot"}.
}
\description{
Create \code{ggplot2} R plots for forecasting objects of class 
\code{"deseats_fc"}.
}
\details{
This is a plot method to visualize the forecasting results for a Seasonal 
Semi-ARMA model. Common plot arguments can be implemented to change the 
appearance.
}
\examples{
\donttest{
est <- s_semiarma(log(EXPENDITURES))
fc <- predict(est, n.ahead = 4)
fc_e <- expo(fc)
autoplot(fc_e)
}

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
