% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-mult-table.R
\name{ds_auto_freq_table}
\alias{ds_auto_freq_table}
\alias{ds_auto_cross_table}
\alias{ds_tway_tables}
\alias{ds_oway_tables}
\title{Multiple One & Two Way Tables}
\usage{
ds_auto_freq_table(data, ...)

ds_auto_cross_table(data, ...)
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble}.}

\item{...}{Column(s) in \code{data}.}
}
\description{
\code{ds_auto_freq_table} creates multiple one way tables by creating
a frequency table for each categorical variable in a data frame.
\code{ds_auto_cross_table} creates multiple two way tables by creating a cross
table for each unique pair of categorical variables in a data frame.
}
\details{
\code{ds_auto_freq_table} is a extension of the \code{ds_freq_table}
function. It creates a frequency table for each categorical variable in the
dataframe. \code{ds_auto_cross_table} is a extension of the \code{ds_cross_table}
function. It creates a two way table for each unique pair of categorical
variables in the dataframe.
}
\section{Deprecated Functions}{

\code{ds_oway_tables()} and \code{ds_tway_tables()} have been deprecated. 
Instead use \code{ds_auto_freq_table()} and \code{ds_auto_cross_table()}.
}

\examples{
# multiple one way tables
ds_auto_freq_table(mtcarz)
ds_auto_freq_table(mtcarz, cyl, gear)

# multiple two way tables
ds_auto_cross_table(mtcarz)
ds_auto_cross_table(mtcarz, cyl, gear, am)
}
\seealso{
\code{link{ds_freq_table}} \code{link{ds_cross_table}}
}
