% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist-normal.R
\name{dist_norm_plot}
\alias{dist_norm_plot}
\alias{norm_plot}
\alias{dist_norm_perc}
\alias{norm_per}
\alias{dist_norm_prob}
\alias{norm_prob}
\title{Visualize normal distribution}
\usage{
dist_norm_plot(mean = 0, sd = 1)

dist_norm_perc(probs = 0.95, mean = 0, sd = 1, type = c("lower",
  "upper", "both"))

dist_norm_prob(perc, mean = 0, sd = 1, type = c("lower", "upper", "both"))
}
\arguments{
\item{mean}{Mean of the normal distribution.}

\item{sd}{Standard deviation of the normal distribution.}

\item{probs}{Probability value.}

\item{type}{Lower tail, upper tail or both.}

\item{perc}{Quantile value.}
}
\value{
Percentile for the \code{probs} based on \code{mean}, \code{sd} and
\code{type} or probability value for \code{perc} based on \code{mean},
\code{sd} and \code{type}.
}
\description{
Visualize how changes in mean and standard deviation affect the
shape of the normal distribution. Compute & visualize quantiles out of given
probability  and probability from a given quantile.
}
\section{Deprecated functions}{

\code{norm_plot()}, \code{norm_prob()} and \code{norm_per()} have been
deprecated. Instead use \code{dist_norm_plot()}, \code{dist_norm_prob()} and
\code{dist_norm_per()}.
}

\examples{
# visualize normal distribution
dist_norm_plot()
dist_norm_plot(mean = 2, sd = 0.6)

# visualize probability from a given quantile
dist_norm_prob(3.78, mean = 2, sd = 1.36)
dist_norm_prob(3.43, mean = 2, sd = 1.36, type = 'upper')
dist_norm_prob(c(-1.74, 1.83), type = 'both')

# visualize quantiles out of given probability
dist_norm_perc(0.95, mean = 2, sd = 1.36)
dist_norm_perc(0.3, mean = 2, sd = 1.36, type = 'upper')
dist_norm_perc(0.95, mean = 2, sd = 1.36, type = 'both')

}
\seealso{
\code{\link[stats]{Normal}}
}
