% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq-cat.R
\name{freq_table}
\alias{freq_table}
\alias{barplot.freq_table}
\title{Frequency Table: Categorical Data}
\usage{
freq_table(data)

\method{barplot}{freq_table}(height, ...)
}
\arguments{
\item{data}{numeric or factor vector}

\item{height}{an object of class \code{freq_table}}

\item{...}{further arguments to be passed to or from methods}
}
\value{
\code{freq_table} returns an object of class \code{"freq_table"}.
An object of class \code{"freq_table"} is a list containing the
following components

\item{ftable}{frequency table}
\item{varname}{name of the data}
}
\description{
\code{freq_table} creates frequency table for factor data and
returns the frequency, cumulative frequency, frequency percent and cumulative
frequency percent. \code{barplot.freq_table} creates bar plot for the
frequency table created using \code{freq_table}
}
\examples{
# frequency table
mt <- mtcars
mt$cyl <- as.factor(mt$cyl)
freq_table(mt$cyl)

# barplot
mt <- mtcars
mt$cyl <- as.factor(mt$cyl)
k <- freq_table(mt$cyl)
barplot(k)
}
\seealso{
\code{link{freq_cont}} \code{link{cross_table}}
}
