% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compound.R
\name{compound}
\alias{compound}
\alias{binormsdist}
\alias{optionsoncall}
\alias{optionsonput}
\alias{calloncall}
\alias{callonput}
\alias{putoncall}
\alias{putonput}
\title{Compound options}
\usage{
binormsdist(x1, x2, rho)
optionsoncall(s, kuo, kco, v, r, t1, t2, d)
optionsonput(s, kuo, kco, v, r, t1, t2, d)
calloncall(s, kuo, kco, v, r, t1, t2, d, returnscritical)
callonput(s, kuo, kco, v, r, t1, t2, d, returnscritical)
putoncall(s, kuo, kco, v, r, t1, t2, d, returnscritical)
putonput(s, kuo, kco, v, r, t1, t2, d, returnscritical)
}
\arguments{
\item{s}{Price of the asset on which the underlying option is
written}

\item{v}{Volatility of the underlying asset, defined as the
annualized standard deviation of the continuously-compounded
return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{d}{Dividend yield of the underlying asset, annualized,
continuously-compounded}

\item{kuo}{strike on the underlying option}

\item{kco}{strike on compound option (the price at which you would
buy or sell the underlying option at time t1)}

\item{t1}{time until exercise for the compound option}

\item{t2}{time until exercise for the underlying option}

\item{x1, x2}{values at which the cumulative bivariate normal
distribution will be evaluated}

\item{rho}{correlation between \code{x1} and \code{x2}}

\item{returnscritical}{(FALSE) boolean determining whether the
function returns just the options price (the default) or the
option price along with the asset price above or below which
the compound option is exercised.}
}
\value{
The option price, and optionally, the stock price above or
    below which the compound option is exercised. The compound
    option functions are not vectorized, but the greeks function
    should work, apart from theta.
}
\description{
A compound option is an option for which the
    underlying asset is an option. The underlying option (the
    option on which there is an option) in turn has an underlying
    asset. The definition of a compound option requires specifying

\itemize{

   \item{whether you have the right to buy or sell an underlying option}

   \item{whether the underlying option (the option upon which there
   is an option) is a put or a call}

   \item{the price at which you can buy or sell the underlying
   option (strike price \code{kco} --- the strike on the compound
   option)}

   \item{the price at which you can buy or sell the underlying
   asset should you exercise the compound option (strike price
   \code{kuo} --- the strike on the underlying option)}


   \item{the date at which you have the option to buy or sell the
   underlying option (first exercise date, \code{t1})}

   \item{the date at which the underlying option expires, \code{t2}}

}

Given these possibilities, you can have a call on a call, a put on
 a call, a call on a put, and a put on a put. The valuation
 procedure require knowing, among other things, the underlying
 asset price at which it will be worthwhile to acquire the
 underlying option.

Given the underlying option, there is a parity relationship: If you
buy a call on a call and sell a call on a call, you have acquired
the underlying call by paying the present value of the strike,
\code{kco}.
}
\note{
The compound option formulas are not vectorized.
}
