% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ROI}
\alias{ROI}
\title{Compute the ROI surfaces given test and vaccine cost fractions.}
\usage{
ROI(rcoeffs, nus = seq(0.3, 0.9, by = 0.05), taus = 10^seq(-2, -0.5, by
  = 0.05))
}
\arguments{
\item{rcoeffs, }{a data.frame with the ROI surface coefficients from \link{ROIcoeffs}}

\item{nus, }{the series of normalized vaccine costs to use for ROI calcs}

\item{taus, }{the series of normalized test costs to use for ROI calcs}
}
\value{
a `data.frame` (`data.table`, if available) with columns:
\describe{
  \item{nu}{numeric, the normalized vaccine cost used}
  \item{tau}{numeric, the normalized test cost used}
  \item{mechanism}{character, either "ordinal" or "binary" corresponding to the type of test}
  \item{A}{integer; the age when routine test-then-vaccinate strategy starts (from \code{As})}
  \item{L}{integer; the maximum number of tests for routine test-then-vaccinate strategy (from \code{Ls})}
  \item{cost}{numeric; the intervention cost (as a fraction of second infection cost)}
  \item{benefit}{
    numeric; the difference in health outcome cost (as a fraction of second infection cost) minus `cost`;
    positive values indicate positive net benefit
  }
  \item{roi}{numeric; return on investment: `benefit` over `cost`}
}
}
\description{
Compute the ROI surfaces given test and vaccine cost fractions.
}
\details{
tabulates ROI
}
\examples{
require(denvax);
data(morrison2010) # has counts by age
fit <- with(morrison2010, serofit(sero=Seropositive, N=Number, age.min=Age))
m2010pop <- synthetic.pop(fit, runs = 10, popsize = 10) # small sample size for example run time
m2010lh <- nPxA(m2010pop)
L <- 5
rc <- ROIcoeffs(m2010lh, As=5:10, Ls=L)
rois <- ROI(rc, nus = 0.5, taus = 0.01)
srois <- subset(rois, mechanism == "binary")
mrois <- matrix(srois$roi, nrow = L)
contour(x=unique(srois$L), y=unique(srois$A), z=mrois,
  xlab = "Max # of Tests", ylab = "Initial Age", main="ROI Contour"
)

}
