% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr_access.R
\name{assign_values_to_leaves_edgePar}
\alias{assign_values_to_leaves_edgePar}
\title{Assign values to edgePar of dendrogram's leaves}
\usage{
assign_values_to_leaves_edgePar(dend, value, edgePar,
  warn = dendextend_options("warn"), ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{value}{a new value vector for the edgePar attribute. It should be 
the same length as the number of leaves in the tree. If not, it will recycle
the value and issue a warning.}

\item{edgePar}{the value inside edgePar to adjust.}

\item{warn}{logical (default from dendextend_options("warn") is FALSE).
Set if warning are to be issued, it is safer to keep this at TRUE,
but for keeping the noise down, the default is FALSE.}

\item{...}{not used}
}
\value{
A dendrogram, after adjusting the edgePar attribute in all of its leaves,
}
\description{
Go through the dendrogram leaves and updates the values inside its edgePar

If the value has Inf then the value in edgePar will not be changed.
}
\examples{

\dontrun{

dend <- USArrests[1:5,] \%>\% dist \%>\% hclust("ave") \%>\% as.dendrogram

plot(dend)
dend <- assign_values_to_leaves_edgePar(dend=dend, value = c(3,2), edgePar = "col")
plot(dend)
dend <- assign_values_to_leaves_edgePar(dend=dend, value = c(3,2), edgePar = "lwd")
plot(dend)
dend <- assign_values_to_leaves_edgePar(dend=dend, value = c(3,2), edgePar = "lty")
plot(dend)

get_leaves_attr(dend, "edgePar", simplify=FALSE)

}

}
\seealso{
\link{get_leaves_attr}, link{assign_values_to_leaves_nodePar}
}
