% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ape.R
\name{as.phylo.dendrogram}
\alias{as.phylo.dendrogram}
\title{Convert a dendrogram into phylo}
\usage{
as.phylo.dendrogram(x, ...)
}
\arguments{
\item{x}{a dendrogram}

\item{...}{ignored.}
}
\value{
A phylo class object
}
\description{
Based on \link{as.hclust.dendrogram} with \link[ape]{as.phylo.hclust}

In the future I hope a more direct link will be made.
}
\examples{
\dontrun{

library(dendextend)
library(ape)
dend <- iris[1:30,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend2 <- as.phylo(dend)
plot(dend2, type = "fan")


# Also possible to with ggplot2 :)

library(dendextend)
library(ggplot2)
library(ggdendro)
dend <- iris[1:30,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
# Rectangular lines
ddata <- dend \%>\% dendro_data(type = "rectangle")
p <- ggplot(segment(ddata)) +
   geom_segment(aes(x = x, y = y, xend = xend, yend = yend)) +
   coord_flip() +
   scale_y_reverse(expand = c(0.2, 0)) + coord_polar(theta="x")
p



}
}
\seealso{
\link{as.dendrogram}, \link{as.hclust}, \link[ape]{as.phylo}
}

