% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaR.R
\docType{package}
\name{deltar}
\alias{deltar}
\alias{deltar-package}
\alias{deltar-package}
\title{Calculation of Delta R Values}
\description{
Computes the regional correction factor of 14C age offset in marine-derived samples (Delta R). This is possible with the recently established “marine13” calibration curve and the 'BchronCalibrate' function from the 'Bchron' package. The algorithm of Delta R computation includes four steps: measure radiocarbon age of a marine sample; identify its true age; compute its modeled radiocarbon age corresponding to the true age; and finally calculate the difference between its measured and modeled radiocarbon ages. This package has functions that compute Delta R with three methods: by using marine samples with known collection dates (before 1950s), usually molluscan shells from museum collections, (function dr_shell()); by measuring other radioactive isotopes, mainly uranium-thorium (230Th/234U), ratio (dr_pair() function and the “pair” method in the dr_df() function); and finally by using a pair of coeval samples, one being marine and the other terrestrial (dr_pair() function and the “pair” method for the dr_df() function as well). Usually such samples originate from archaeological sites where the context, in which paired samples were found, is taken as a guarantee of their synchronicity. \cr References: \cr Oeschger H, Siegenthaler U, Schotterer U, Gugelmann A. 1975. A box diffusion model to study the carbon dioxide exchange in nature. Tellus 27(2): 168–92. \cr \cr Reimer PJ, Bard E, Bayliss A, Beck JW, Blackwell PG, Bronk Ramsey C, Buck CE, Cheng H, Edwards RL, Friedrich M, Grootes PM, Guilderson TP, Haflidason H, Hajdas I, Hatté C, Heaton TJ, Hoffmann DL, Hogg AG, Hughen KA, Kaiser KF, Kromer B, Manning SW, Niu M, Reimer RW, Richards DA, Scott EM, Southon JR, Staff RA, Turney CSM, van der Plicht J. 2013. IntCal13 and Marine13 radiocarbon age calibration curves 0–50,000 years cal BP. Radiocarbon 55(4): 1869–87. \cr \cr Soulet G. 2015. Methods and codes for reservoire atmosphere 14C age offset Calculations. Quaternary Geochronology.  29: 97-103. \cr \cr Stuiver M, Braziunas TF. 1993. Modeling atmospheric 14C influences and 14C ages of marine samples to 10,000 BC. Radiocarbon 35(1):137–89.
}
\section{deltar functions}{

\code{\link{dr_shell}} for marine samples with known collection date, \code{\link{dr_pair}} for a sample which has its true age identified, \code{\link{dr_df}} for a set of dates contained in a data frame, and \code{\link{dr_plot}} for plotting Delta R values from a list produced by \code{\link{dr_df}}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/teemour/deltaR}
}

}
