% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputeMechanism.R
\name{CreateNewImputeMechanism}
\alias{CreateNewImputeMechanism}
\title{A function which creates an Impute Mechanism object}
\usage{
CreateNewImputeMechanism(
  name,
  cols.needed = vector("character"),
  impute,
  parameters = NULL
)
}
\arguments{
\item{name}{The method name (used for printing)}

\item{cols.needed}{which columns of the SingleSim data frame are required by the method, typically
\code{c("censored.time","observed.events","arm")}}

\item{impute}{A function which takes a \code{SingleSimFit} object and outputs the details for a single
imputed data set, specifically a list with two elements:
\code{new.censored.times} - a vector of times subjects were censored (after taking into account imputation)
and \code{newevent.times} - a list of vectors where the vectors contain the imputed event times for the subjects
(these vectors do not contain the observed event times before subject drop out). If a subject has no imputed events then 
the vector \code{numeric(0)} is returned.}

\item{parameters}{A list of named parameters describing the method (used for printing) - or NULL if none}
}
\value{
A \code{\link{ImputeMechanism.object}}
}
\description{
A function which creates an Impute Mechanism object
}
\seealso{
\code{\link{ImputeMechanism.object}}
}
