% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_screen-grid-layer.R
\name{add_screen_grid_layer}
\alias{add_screen_grid_layer}
\title{Add a screen grid layer to the deckgl widget}
\usage{
add_screen_grid_layer(deckgl, id = "screen-grid-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{id}{id of the layer}

\item{data}{url to fetch data from or data object}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\description{
The \code{ScreenGridLayer} takes in an array of latitude and longitude coordinated points,
aggregates them into histogram bins and renders as a grid.
}
\examples{
## @knitr screen-grid-layer
sample_data <- paste0(
  "https://raw.githubusercontent.com/uber-common/",
  "deck.gl-data/master/",
  "website/sf-bike-parking.json"
)

properties <- list(
  pickable = FALSE,
  opacity = 0.8,
  cellSizePixels = 50,
  minColor = c(0, 0, 0, 0),
  maxColor = c(0, 180, 0, 255),
  getPosition = get_property("COORDINATES"),
  getWeight = get_property("SPACES")
)

deck <- deckgl() \%>\%
  add_screen_grid_layer(data = sample_data, properties = properties) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/screen-grid-layer}
}
