% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mddsPLS.R
\name{mddsPLS}
\alias{mddsPLS}
\title{Multi-Data-Driven sparse PLS function.}
\usage{
mddsPLS(Xs, Y, lambda = 0, R = 1, mode = "reg", L0 = NULL,
  keep_imp_mod = FALSE, reg_imp_model = TRUE, errMin_imput = 1e-09,
  maxIter_imput = 50, verbose = FALSE, NZV = 1e-09,
  getVariances = TRUE)
}
\arguments{
\item{Xs}{A matrix, if there is only one block, or a list of matrices,, if there is more than one block, of \strong{n} rows each, the number of individuals. Some rows must be missing. The different matrices can have different numbers of columns. The length of Xs is denoted by \strong{K}.}

\item{Y}{A matrix of \strong{n} rows of a vector of length \strong{n} detailing the response matrix. No missing values are allowed in that matrix.}

\item{lambda}{A real \eqn{[0,1]} where 1 means just perfect correlations will be used and 0 no regularization is used.}

\item{R}{A strictly positive integer detailing the number of components to build in the model.}

\item{mode}{A character chain. Possibilities are "\strong{(reg,lda,logit)}", which implies regression problem, linear discriminant analysis (through the paclkage \code{MASS}, function \code{lda}) and logistic regression (function \code{glm}). Default is \strong{reg}.}

\item{L0}{An integer non nul parameter giving the largest number of X variables that can be selected.}

\item{keep_imp_mod}{Logical. Whether or not to keep imputation \strong{mddsPLS} models. Initialized to \code{FALSE} due to the potential size of those models.}

\item{reg_imp_model}{Logical. Whether or not to regularize the imputation models. Initialized to \code{TRUE}.}

\item{errMin_imput}{Positive real. Minimal error in the Tribe Stage of the Koh-Lanta algorithm. Default is \eqn{1e-9}.}

\item{maxIter_imput}{Positive integer. Maximal number of iterations in the Tribe Stage of the Koh-Lanta algorithm. If equals to \eqn{0}, mean imputation is  considered. Default is \eqn{5}.}

\item{verbose}{Logical. If TRUE, the function cats specificities about the model. Default is FALSE.}

\item{NZV}{Float. The floatting value above which the weights are set to 0.}

\item{getVariances}{Logical. Whether or not to compute variances.}
}
\value{
A list containing a mddsPLS object, see \code{\link{MddsPLS_core}}. The \code{list} \code{order_values} is filled with the selected genes in each block.
They are oredered according to the sum of the square values of the \strong{Super-Weights} along the \code{R} dimensions.
The \code{rownames} give the names of the selected variables, if no name is given to the columns of \strong{Xs}, simply the indices are given.
Plus the \strong{Weights} and \strong{Super-Weights} are given for each of the selected variables in every \strong{R} dimension.
If \code{getVariances} is \code{TRUE} then the \code{Variances} is filled with two types of variances corresponding to bounds between components, or super-components and \strong{Y} vraiables, taken together or splitted.
Both of the types of variances are computed as follows:
\enumerate{
\item \strong{Linear}. Multivariate-linear regression matrix minimizing the Ordinary Least Squares problem is computed. Is then returned the fraction of the variance of the therefore model divide by the variance observed.
This represents the variance of the to be predicted parts by the predictors under a linear model.
\item \strong{RV}. That coefficient has permits to extend the correlation notion to matrices with the same number of rows but not necessarilye with the same number of columns \insertCite{@see @robert1976unifying}{ddsPLS}.
}
}
\description{
This function takes a set \eqn{X} of \eqn{K} matrices defining the same \eqn{n} individuals and a matrix \eqn{Y} defining also those individuals. According to the num-
ber of components \eqn{R}, the user fixes the number of components the model
must be built on. The coefficient lambda regularizes the quality of proximity to the data choosing to forget the least correlated bounds between
\eqn{X} and \eqn{Y} data sets.
}
\examples{
# Single-block example :
## Classification example :
data("penicilliumYES")
X <- penicilliumYES$X
X <- scale(X[,which(apply(X,2,sd)>0)])
Y <- as.factor(unlist(lapply(c("Melanoconidiu","Polonicum","Venetum"),function(tt){rep(tt,12)})))
# mddsPLS_model_class <- mddsPLS(Xs = X,Y = Y,R = 2,L0=3,mode = "lda",verbose = TRUE)
# summary(mddsPLS_model_class,plot_present_indiv = FALSE)

## Regression example :
data("liverToxicity")
X <- scale(liverToxicity$gene)
Y <- scale(liverToxicity$clinic)
#mddsPLS_model_reg <- mddsPLS(Xs = X,Y = Y,L0=10,R = 1, mode = "reg",verbose = TRUE)
#summary(mddsPLS_model_reg)

# Multi-block example :
## Classification example :
data("penicilliumYES")
X <- penicilliumYES$X
X <- scale(X[,which(apply(X,2,sd)>0)])
Xs <- list(X[,1:1000],X[,-(1:1000)])
Xs[[1]][1:5,]=Xs[[2]][6:10,] <- NA
Y <- as.factor(unlist(lapply(c("Melanoconidiu","Polonicum","Venetum"),function(tt){rep(tt,12)})))
#mddsPLS_model_class <- mddsPLS(Xs = Xs,Y = Y,L0=3,mode = "lda",R = 2,verbose = TRUE)
#summary(mddsPLS_model_class)

## Regression example :
data("liverToxicity")
X <- scale(liverToxicity$gene)
Xs <- list(X[,1:1910],X[,-(1:1910)])
Xs[[1]][1:5,]=Xs[[2]][6:10,] <- NA
Y <- scale(liverToxicity$clinic)
#mddsPLS_model_reg <- mddsPLS(Xs = Xs,Y = Y,lambda=0.9,R = 1, mode = "reg",verbose = TRUE)
#summary(mddsPLS_model_reg)
}
\references{
{
  \insertAllCited{}
}
}
\seealso{
\code{\link{summary.mddsPLS}}, \code{\link{plot.mddsPLS}}, \code{\link{predict.mddsPLS}}, \code{\link{perf_mddsPLS}}, \code{\link{summary.perf_mddsPLS}}, \code{\link{plot.perf_mddsPLS}}
}
