% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnpp_experiment-filled.R
\name{get_filled_border}
\alias{get_filled_border}
\title{Get border of filled droplets in PNPP experiment}
\usage{
get_filled_border(plate, well_id)
}
\arguments{
\item{plate}{A ddPCR plate.}

\item{well_id}{Get border of filled droplets for this well.}
}
\value{
Thresholds of filled drops in the positive dimension.
}
\description{
In a PNPP experiment, the rain droplets are the non-empty drops that don't have a
high enough intensity in the positive dimension to be considered as filled
with high quality sample DNA. Only droplets considered as filled are
candidates for the \code{negative} and \code{positive} clusters.
\code{get_filled_border} returns the threshold value in the positive
dimension that is used to determine which drops are filled.
}
\examples{
file <- system.file("sample_data", "small", "analyzed_pnpp.rds", package = "ddpcr")
plate <- load_plate(file)
get_filled_border(plate, "A05")
get_filled_border(plate, "F05")
}
\seealso{
\code{\link[ddpcr]{pnpp_experiment}}\cr
\code{\link[ddpcr]{positive_dim}}\cr
\code{\link[ddpcr]{get_filled_drops}}
}
\keyword{internal}
