% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-custom_thresholds.R
\name{x_threshold}
\alias{x_threshold}
\alias{x_threshold<-}
\title{Get/set the X threshold}
\usage{
x_threshold(plate)

x_threshold(plate) <- value
}
\arguments{
\item{plate}{A ddPCR plate.}

\item{value}{The new X threshold}
}
\value{
The current X threshold
}
\description{
For ddPCR plates of type \code{custom_thresholds}, get or set the threshold
along the X axis that divides the droplet quadrants.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$custom_thresholds)
x_threshold(plate)
x_threshold(plate) <- 5500
plot(plate)
}
}
\seealso{
\code{\link[ddpcr]{custom_thresholds}}\cr
\code{\link[ddpcr]{y_threshold}}\cr
\code{\link[ddpcr]{thresholds}}
}
