% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnpp_experiment-classify.R
\name{classify_droplets}
\alias{classify_droplets}
\title{Analysis step: Classify droplets}
\usage{
classify_droplets(plate)
}
\arguments{
\item{plate}{A ddPCR plate.}
}
\value{
A ddPCR plate with all droplets assigned to a cluster. The plate's
metadata will have several new variables.
}
\description{
The main analysis step for ddPCR plates of type \code{pnpp_experiment}.
Classify each droplet as either rain, ++, or +-. Also calculate the frequency
of negative droplets, and attempt to detemine if each well has a statistically
significant number of such droplets.\cr\cr
\href{https://github.com/daattali/ddpcr#advanced-topic-2-algorithms-used-in-each-step}{See the README} for
more information about the algorithm used.
}
\details{
This function is recommended to be run as part of an analysis pipeline (ie.
within the \code{\link[ddpcr]{analyze}} function) rather than being called
directly.
}
\note{
This is an S3 generic, which means that different ddPCR plate types can
implement this function differently.
\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on how to implement custom ddPCR plate types.
}
\seealso{
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{classify_droplets_single}}\cr
\code{\link[ddpcr]{mark_clusters}}\cr
\code{\link[ddpcr]{has_signif_negative_cluster}}
}
\keyword{internal}
