\name{mcmc_ddepn}
\alias{mcmc_ddepn}
\alias{runmcmc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
mcmc_ddepn - Perform MCMC sampling for DDEPN.
}
\description{
MCMC sampling for DDEPN. Takes an initial network and samples from the posterior. \code{runmcmc}
is a wrapper function for multiple calls of \code{mcmc_ddepn}, in case that multiple cores
are used for parallel MCMC runs.
}
\usage{
mcmc_ddepn(dat, phiorig=NULL, phi=NULL, stimuli=NULL,
    th=0.8, multicores=FALSE, outfile=NULL, maxiterations=10000,
    usebics=FALSE, cores=2, lambda=NULL, B=NULL,Z=NULL,
    samplelambda=NULL, hmmiterations=30, fanin=4,
    gam=NULL, it=NULL, K=NULL, burnin=1000, priortype="laplaceinhib",
    plotresults=TRUE,always_sample_sf=FALSE, scale_lik=FALSE, 
    allow.stim.off=TRUE,debug=0,retobj=NULL, implementation="C")
    
runmcmc(x,dat,phiorig,phi,stimuli,th,multicores,outfile,maxiterations,
		usebics,cores,lambda,B,Z,samplelambda,hmmiterations,
		fanin,gam,it,K,burnin,priortype,
		plotresults=TRUE,always_sample_sf=FALSE, 
		scale_lik=FALSE, allow.stim.off=TRUE,debug=0,
		retobj=NULL, implementation="C")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dat}{The data matrix.}
  \item{phiorig}{The reference network to compare to. Can be NULL.}
  \item{phi}{The start network. Empty if NULL.}
  \item{stimuli}{The stimuli list.}
  \item{th}{Threshold for inclusion of an edge in the final network.}
  \item{multicores}{Use multiple cores. Not used here.}
  \item{outfile}{File to which the network should be drawn.}
  \item{maxiterations}{Integer. Maximum number of MCMC iterations.}
  \item{usebics}{Use bics for model selection.}
  \item{cores}{Not used here.}
  \item{lambda}{NULL, Numeric or NA. The Prior influence hyperparameter for the laplace prior. If 
   numeric, used as fixed prior strength or starting value for prior strength sampling
   (when \code{samplelambda} is numeric, too). If NA, lambda is integrated out in the 
   calculation of the prior. If NULL, no laplace prior is used.}
  \item{B}{The Prior information matrix. See \code{\link{prior}} for details.}
  \item{Z}{Normalisation factor for prior.}
  \item{hmmiterations}{Maximum iterations in the HMM.}
  \item{fanin}{Integer: maximal indegree for nodes.}
  \item{gam}{Prior influence strength in scalefree prior.}
  \item{it}{Number of iterations to generate background distribution in scalefree prior.}
  \item{K}{Proportionality factor in scalefree prior}
  \item{samplelambda}{Numeric or NULL. If NULL, the Laplace hyperparameter \code{lambda} is 
    kept fix during the MCMC inference. If numeric, \code{lambda} is sampled uniformly around the 
    initial value of \code{lambda}, with an interval size defined by \code{samplelambda}.}
  \item{x}{List containing two items: An adjacency matrix \code{phi} and a string \code{outfile} describing
    a path.}
  \item{burnin}{Integer. Specifies the number of iterations used as burnin phase for
   \code{\link{mcmc_ddepn}}.}
  \item{priortype}{Character. One of \code{none}, \code{laplaceinhib}, \code{laplace} or
   \code{scalefree} for use of the respective prior type. Ignored if \code{usebics=TRUE}. For 
   \code{netga}, \code{usebics=FALSE, priortype="none"} means optimising the likelihood 
   directly, for \code{mcmc_ddepn}, \code{none} is not allowed.} 
  \item{plotresults}{Boolean. If TRUE, some statistics are plotted while inhibMCMC is running.} 
  \item{always_sample_sf}{Boolean. Update scaling factor in inhibMCMC sampling through the whole sampling
   if TRUE. Keep scaling factor fixed after burn-in if FALSE.}
  \item{scale_lik}{Boolean. Perform scaling of the likelihood according to how 
   many data points were used to calculate the overall likelihood.}
  \item{allow.stim.off}{Boolean. If TRUE, the stimulus can become passive at some time. This will generate additional
    reachable system states, in particular all states from the normal state matrix, generated by 
    the propagation, but with the stimulus node set to 0.}
  \item{debug}{Numeric. If 0, a status bar indicates the progress of the algorithm. If 1 or 2, 
    extra information is printed to the console (for \code{debug=2} more information than 
    for \code{debug=1}).}
  \item{retobj}{List. The output generated during an inhibMCMC run (see \code{\link{ddepn}} for argument 
    \code{inference="mcmc"}). Passed by function \code{resume_ddepn} to resume the inference.}
  \item{implementation}{String. One of \code{"C","R","R_globalest","C_globalest"}. Different implementations of the HMM in 
    \code{\link{perform.hmmsearch}}. If \code{"R"}, the original pure R-implementation is 
    used, if \code{"C"}, a ported C-implementation is used. If \code{"R_globalest"}, an experimental version of
    the parameter estimation is used in the HMM, \code{"C_globalest"} is the C-port of 
    this version. See \code{details} for a description.}
}
\details{
Usually this function is called internally by \code{\link{ddepn}}.
}
\value{
  A list of the following elements:
  \item{phi}{The inferred network.}
  \item{L}{Likelihood.}
  \item{aic}{Akaikes Information Criterion.}
  \item{bic}{Bayesian Information Criterion.}
  \item{posterior}{Posterior probability.}
  \item{dat}{The data matrix.}
  \item{theta}{The parameter matrix for the gaussians.}
  \item{gamma}{The state transition matrix.}
  \item{gammaposs}{The theoretical state transition matrix, as generated by the effect propagation.}
  \item{tps}{A list. Each element is a vector of time points for each experiment in the data matrix.}
  \item{stimuli}{List of stimuli.}
  \item{reps}{Number of replicates for each experiment.}
  \item{hmmiterations}{Maximum number of iterations during an HMM run.}
  \item{lastmove}{Type of the last change that was performed.}
  \item{coords}{Position in the network where the last change was performed.}
  \item{lambda}{Laplace prior hyperparameter.}
  \item{B}{Laplace prior matrix.}
  \item{Z}{Laplace prior normalisation factor. (Not used at the moment.)}
  \item{pegm}{Probability of performing the last move.}
  \item{pegmundo}{Probability of reverting the last move.}
  \item{nummoves}{Total number of possible moves in the current step.}  
  \item{fanin}{Maximal indegree for nodes.}
  \item{gam}{Sparsity prior hyperparameter.}
  \item{it}{Sparsity prior iterations.}
  \item{K}{Sparsity prior scaling factor.}
  \item{conf.act}{Matrix of beliefs that an edge is an activation. (equals \eqn{freqa/eoccur})}
  \item{conf.inh}{Matrix of beliefs that an edge is an inhibition. (equals \eqn{freqi/eoccur})}
  \item{eoccur}{Matrix of total occurrences of edges. }
  \item{phi.orig}{Adjacency of reference network, if given. }
  \item{stats}{Matrix of scores and statistics recorded during MCMC.}
  \item{freqa}{Counts how often an edge was an activation.}
  \item{freqi}{Counts how often an edge was an activation.}
  \item{mu_run}{The running mean values of the parameters in theta.}
  \item{Qi}{A helper for the calculation of sd_run.}
  \item{sd_run}{The running standard deviations of the parameters in theta.}
}
\references{
TODO
}
\author{
Christian Bender
}
\note{
TODO
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ddepn}}
}
\examples{
\dontrun{
## load package
library(ddepn)

## sample a network
n <- 6
signet <- signalnetwork(n=n, nstim=2, cstim=0, prop.inh=0.2)
phit <- signet$phi
stimuli <- signet$stimuli

## sample data
dataset <- makedata(phit, stimuli, mu.bg=1200, sd.bg=400, 
	mu.signal.a=2000, sd.signal.a=1000)

## prior normalisation factor
lambda <- 0.01 

## network to start with
V <- rownames(dataset$datx)
phistart <- matrix(0, nrow=n, ncol=n, dimnames=list(V,V))

## use original network as prior matrix
## reset all entries for inhibiting edges 
## to -1
B <- phit
B[B==2] <- -1

## now the sampling
ret <- mcmc_ddepn(dataset$datx, phiorig=phit, phi=phistart, stimuli=stimuli,
            th=0.8, multicores=FALSE, outfile=NULL, maxiterations=300,
            usebics=FALSE, cores=1, lambda=lambda, B=B,
            hmmiterations=100, fanin=4, burnin=100, priortype="laplaceinhib")
}

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
